const form = document.getElementById("formularioCurso");
const nome = document.getElementById("nome");
const periodo = document.getElementById("periodo");
const nota = document.getElementById("nota");
const btn = document.getElementById("btn-submit");

let number = new RegExp('^[0-9]+$');
let letter = new RegExp('^[a-zA-Z ]+$');

nome.addEventListener("keyup", function(){
	let small = nome.parentElement.querySelector("small");
	if(nome.value === ''){
		nome.className = "form-control is-warning";
		small.style.visibility = "visible";
		small.style.color = "#ffc107";
		small.innerText = "Campo nome é um campo obrigatório!";
        btn.setAttribute('disabled', 'disabled');
	} else {
		nome.className = "form-control is-valid";
		btn.removeAttribute('disabled');
		small.style.visibility = "hidden";
		
	}
});

btn.addEventListener("click", function(){
	if($("#periodo").val() == 0){
		let small = periodo.parentElement.querySelector("small");
		periodo.classList.add("select2-danger");
		small.style.visibility = "visible";
		small.style.color = "#dc3545";
		small.innerText = "Selecione um período!";
		btn.setAttribute('disabled', 'disabled');
	}
});

$('#periodo').select2().on('change', function(){
    let small = periodo.parentElement.querySelector("small");
    console.log($("#periodo").val());
    if($("#periodo").val() == 0){
		periodo.classList.add("select2-danger");
		small.style.visibility = "visible";
		small.style.color = "#dc3545";
		small.innerText = "Selecione um período!";
        btn.setAttribute('disabled', 'disabled');
    } else {
		periodo.classList.remove("select2-danger");
        periodo.style.borderColor = "#ffc107";
		btn.removeAttribute('disabled');
		small.style.visibility = "hidden";
    }
});

nota.addEventListener("keyup", function(){
	if(nota.value === ''){
		nota.className = "form-control";
		btn.removeAttribute('disabled');
		small.style.visibility = "hidden";
	} else {
		nota.className = "form-control is-valid";
		btn.removeAttribute('disabled');
		small.style.visibility = "hidden";
	}
});
