<!DOCTYPE html>
<html lang="pt-pt">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Listagem turma</title>
  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../../plugins/fontawesome-free/css/all.min.css">
  <!-- Select2 -->
  <link rel="stylesheet" href="../../plugins/select2/css/select2.min.css">
  <link rel="stylesheet" href="../../plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="../../plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="../../plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="../../plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../../dist/css/adminlte.min.css">
  <link rel="stylesheet" href="../../style.css">
</head>
<body class="sidebar-mini iframe-mode">
<div class="wrapper">
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header" style="padding: 10px .5rem;">
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
            <div class="row">
                <div class="col-12">

                <div class="card">
                    <div class="card-header">
                      <div class="col-sm-6">
                        <div class="form-group margem">
                          <p class="card-title breadcrumb-item active" style="padding: .375rem;">Listagem - Turma</p>
                        </div>
                      </div>
                      <div class="float-sm-right col-md-2">
                        <div class="form-group margem">
                          <a href="../formulario/turma.php" class="btn btn-block btn-outline-success">Adicionar turma</a>
                        </div>
                      </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                    <table id="tabelaTurma" class="table table-bordered table-striped" style="line-height: 0.8;">
                    <thead>
                        <tr>
                          <th title="Identificador da turma">Id turma</th>
                          <th title="Período da turma">Período</th>
                          <th title="Curso da turma">Curso</th>
                          <th title="Nome da turma">Nome</th>
                          <th title="Número total de alunos da turma">Capacidade</th>
                          <th title="Anotação da turma">Nota</th>
                        </tr>
                    </thead>
                    <tbody id="corpoTabela">
                        
                    </tbody>
                    </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
            </div>
        </section>
        <div class="modal fade" id="modal-updateTurma">
        <div class="modal-dialog modal-lg">
          <div class="modal-content">
            <div class="modal-header" style="padding: 0.5rem;">
                <h3 class="card-title p-3">Turma: <span id="nomeModal"></span></h3>
                <ul class="nav nav-pills ml-auto p-2">
                  <li class="nav-item" style="margin-right: 0.4rem;"><a class="nav-link active" href="#tab_info" data-toggle="tab">Informações</a></li>
                  <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" data-toggle="dropdown" href="#">
                      Acções <span class="caret"></span>
                    </a>
                    <div class="dropdown-menu">
                      <a class="dropdown-item" tabindex="-1" href="#tab_editar" data-toggle="tab">Editar</a>
                      <div class="dropdown-divider"></div>
                      <a class="dropdown-item" tabindex="-1" href="#btn-delete" id="btn-delete">Eliminar</a>
                    </div>
                  </li>
                </ul>
            </div>
            <div class="modal-body" style="padding-bottom: 0px;">
            <div class="tab-content">
              <div class="tab-pane active" id="tab_info">
                <div class="row">
                  <div class="col-md-12">
                    <form name="tabelaTurma">
                      <table name="tabelaTurma" class="table table-sm table-bordered" style="min-width: 100%;
                      max-width: 100%;">
                        <tr name="linhaItem">
                          <td style="padding: 20px 0px 0px 10px;">
                            <p>Código da turma: <span id="codigoInfo"></span></p>
                            <p>Nome da turma: <span id="nomeInfo"></span></p>
                            <p>Período turma: <span id="periodoInfo"></span></p>
                            <p>Curso turma: <span id="cursoInfo"></span></p>
                            <p>Capacidade (turma): <span id="capacidadeInfo"></span></p>
                            <p>Professores: <span id="professorInfo"></span></p>
                            <p>Nota turma: <span id="notaInfo"></span></p>
                          </td>
                        </tr>
                      </table>
                    </form>
                  </div>
                </div>
              </div>
              <!-- /.tab-pane -->
              <div class="tab-pane" id="tab_editar">
              <div class="row">
                <div class="col-md-4">
                  <div class="form-group margem">
                      <select class="form-control select2" style="width: 100%;" id="periodo" name="periodo" title="Escolha um período">
                      </select>
                      <small>Mensagem de erro</small>
                  </div>
                  <div class="form-group margem">
                      <select class="form-control select2" style="width: 100%;" id="curso" name="curso" title="Escolha um curso">
                      <option value='0'>Selecione curso</option>
                      </select>
                      <small>Mensagem de erro</small>
                  </div>
                  <div class="form-group margem">
                    <select class="select2" multiple="multiple" id="professor" name="professor[]" data-placeholder="Selecione um ou mais professores" style="width: 100%;">
                    </select>
                    <small>Mensagem de erro</small>
                  </div>
                </div>
                  <div class="col-md-4">
                      <div class="form-group margem">
                          <input type="text" class="form-control" id="nome" name="nome" placeholder="*Nome da turma" title="Nome da turma">
                          <small>Mensagem de erro</small>
                      </div>
                      <div class="form-group margem">
                          <input type="text" class="form-control" id="capacidade" name="capacidade" placeholder="*Capacidade da turma" title="Número total de alunos">
                          <small>Mensagem de erro</small>
                      </div>
                      <div class="form-group margem">
                          <textarea name="nota" class="form-control" id="nota" rows="1" placeholder="Nota..." title="Nota"></textarea>
                          <small>Mensagem de erro</small>
                      </div>
                      <div class="form-group">
                          <button type="submit" name="btn-submit" id="btn-submit" class="btn btn-block btn-outline-primary">Gravar alterações</button>
                      </div>
                  </div>
              </div>
              </div>
            </div>
        </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
      </div>
    <!-- /.content -->
  </div>
  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->
<!-- jQuery -->
<script src="../../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- DataTables  & Plugins -->
<script src="../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
<script src="../../plugins/jszip/jszip.min.js"></script>
<script src="../../plugins/pdfmake/pdfmake.min.js"></script>
<script src="../../plugins/pdfmake/vfs_fonts.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.html5.min.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.print.min.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.colVis.min.js"></script>
<script src="../../plugins/select2/js/select2.full.min.js"></script>
<!-- AdminLTE App -->
<script src="../../dist/js/adminlte.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="../../dist/js/demo.js"></script>
<!-- Page specific script -->
<script>

$(function () {
    //Initialize Select2 Elements
    $('.select2').select2()

    //Initialize Select2 Elements
    $('.select2bs4').select2({
      theme: 'bootstrap4'
    });
});

$(document).ready(function(){
    $.ajax({
        url: "../../php/selectAluno.php",
        type: "post",
        dataType: "json"
    }).done(function(data){
        console.log(data);
    });
});

$(document).ready(function(){
    $.ajax({
        url: "../../php/read/turma.php",
        type: "post",
        dataType: "json"
    }).done(function(data){
        $("#tabelaTurma").DataTable({
        "aaData": data,
        "columns": [{data: "idTurma"}, {data: "periodo"}, {data: "curso"}, {data: "nome"}, {data: "capacidade"}, {data: "nota"}],
        "responsive": true, "lengthChange": false, "autoWidth": false, "language": idiomaPortugues, 
        lengthMenu: [[7, 25, 50, -1], [10, 25, 50, 'All']], 
        "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#tabelaTurma_wrapper .col-md-6:eq(0)');
    });
});

var idiomaPortugues = {
  buttons: {
      copy: "Copiar",
      print: "Imprimir",
      colvis: "Visibilidade"
  },
  "sProcessing": "A processar...",
  "sLengthMenu": "Mostrar _MENU_ dos registros",
  "sZeroRecords": "Sem resultados!",
  "sEmptyTable": "Tabela sem dados disponíveis",
  "sInfo": "De _START_ à _END_ de um total de _TOTAL_ registros",
  "sInfoEmpty": "De 0 à 0 de um total de 0 registros",
  "sInfoFiltered": "(filtrado de um total de _MAX_ registros)",
  "sInfoPostFix": "",
  "sSearch": "Pesquisar:",
  "sUrl": "",
  "sInfoThousands": ",",
  "sLoadingRecords": "A carregar...",
  "oPaginate": {
      "sFirst": "Primeira",
      "sLast": "Última",
      "sNext": "Seguinte",
      "sPrevious": "Anterior"
  },
  "oAria": {
      "sSortAscending": ": Activar para ordenar a coluna de forma ascendente",
      "sSortDescending": ": Activar para ordenar a coluna de forma descendente"
  }
}

$(document).ready(function(){
  $.ajax({
    url: "../../php/select/professor.php",
    type: "post",
    dataType: "json",
    success: function(data){
      let select = "";
      for(var key in data){
        select += "<option value="+data[key]['idUsuario']+">"+data[key]['nome']+"</option>";
      }
      console.log(select);
      $("#professor").html(select);
    }
  });
});

$(document).ready(function(){
  $.ajax({
    url: "../../php/select/periodo.php",
    type: "post",
    dataType: "json",
    success: function(data){
      let select = "";
      select += "<option value='0'>Selecione periodo</option>";
      for(var key in data){
        select += "<option value="+data[key]['idPeriodo']+">"+data[key]['nome']+"</option>";
      }
      console.log(select);
      $("#periodo").html(select);
    }
  });
});

$(document).on("change", "#periodo", function(e){
  e.preventDefault();
  var periodo = $(this).val();
  $.ajax({
    url: "../../php/select/queryCurso.php",
    type: "post",
    dataType: "json",
    data: {
      periodo: periodo
    },
    success: function(data){
      let select = "";
      select += "<option value='0'>Selecione curso</option>";
      for(var key in data){
        select += "<option value="+data[key]['idCurso']+">"+data[key]['nome']+"</option>";
      }
      console.log(select);
      $("#curso").html(select);
    }
  });
});


$('#tabelaTurma tbody').on('click', 'td', function () {
    let tabela = document.getElementById("tabelaTurma");
    
    for(i = 1; i < tabela.rows.length; i++){
      tabela.rows[i].ondblclick = function(){
          idTurma = this.cells[0].innerHTML;
          console.log(idTurma);
          ajax();
          //$('#modal-lg').modal('show');
          //this.classList.remove("selected");
      }
    }

    function ajax(){

      $.ajax({
        url: "../../php/read/queryProfessorTurma.php",
        type: "post",
        dataType: "json",
        data: {
          idTurma: idTurma
        },
        success: function(data){
          let select2 = "";
          let prof = document.getElementById("professor");
          for(var key in data){
            professorInfo.innerText = "";
            let professor = data[key]['professor'];
            console.log("Professor: ", professor);
            $.ajax({
              url: "../../php/read/queryProfessor.php",
              type: "post",
              dataType: "json",
              data: {
                idProfessor: professor
              },
              success: function(data){
                professorInfo = document.getElementById("professorInfo");
                
                for(var key in data){
                  
                  professorInfo.innerText += data[key]['nome'];
                  professorInfo.innerText += ", ";
                  select2 += `
                    
                  `;
                  console.log("Valor do select22222: ", prof);
                  //professor.innerHTML = select2;
                }
              }
            });
            /*nomeModal.innerText = data[key]['nome'];
            
            $('#periodo').val(data[key]['idPeriodo']);
            $('#periodo').select2().trigger('change');

            $('#curso').val(data[key]['idCurso']);
            $('#curso').select2().trigger('change');*/

          }
        }
      }).done(function(data){
        //$('#modal-updateTurma').modal('show');
      });

      $.ajax({
        url: "../../php/read/queryTurma.php",
        type: "post",
        dataType: "json",
        data: {
          idTurma: idTurma
        },
        success: function(data){
          codigoInfo = document.getElementById("codigoInfo");
          nomeInfo = document.getElementById("nomeInfo");
          periodoInfo = document.getElementById("periodoInfo");
          cursoInfo = document.getElementById("cursoInfo");
          capacidadeInfo = document.getElementById("capacidadeInfo");
          notaInfo = document.getElementById("notaInfo");

          nomeUpdate = document.getElementById("nome");
          periodoUpdate = document.getElementById("periodo");
          cursoUpdate = document.getElementById("curso");
          professorUpdate = document.getElementById("professor");
          capacidadeUpdate = document.getElementById("capacidade");
          notaUpdate = document.getElementById("nota");
          
          for(var key in data){
            nomeModal.innerText = data[key]['nome'];
            codigoInfo.innerText = data[key]['idTurma'];
            nomeInfo.innerText = data[key]['nome'];
            periodoInfo.innerText = data[key]['periodo'];
            cursoInfo.innerText = data[key]['curso'];
            capacidadeInfo.innerText = data[key]['capacidade'];
            notaInfo.innerText = data[key]['nota'];

            nomeUpdate.value = data[key]['nome'];

            $('#periodo').val(data[key]['idPeriodo']);
            $('#periodo').select2().trigger('change');

            $('#curso').val(data[key]['idCurso']);
            $('#curso').select2().trigger('change');

            capacidadeUpdate.value = data[key]['capacidade'];
            notaUpdate.value = data[key]['nota'];
          }
        }
      }).done(function(data){
        $('#modal-updateTurma').modal('show');
      });
      
    }
});
</script>
</body>
</html>
