<!DOCTYPE html>
<html lang="pt-pt">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Listagem duração</title>
  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../../plugins/fontawesome-free/css/all.min.css">
  <!-- Select2 -->
  <link rel="stylesheet" href="../../plugins/select2/css/select2.min.css">
  <link rel="stylesheet" href="../../plugins/daterangepicker/daterangepicker.css">
  <link rel="stylesheet" href="../../plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="../../plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="../../plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="../../plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../../dist/css/adminlte.min.css">
  <link rel="stylesheet" href="../../style.css">
</head>
<body class="sidebar-mini iframe-mode">
<div class="wrapper">
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header" style="padding: 10px .5rem;">
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
            <div class="row">
                <div class="col-12">

                <div class="card">
                    <div class="card-header">
                      <div class="col-sm-6">
                        <div class="form-group margem">
                          <p class="card-title breadcrumb-item active" style="padding: .375rem;">Listagem - Duração</p>
                        </div>
                      </div>
                      <div class="float-sm-right col-md-2">
                        <div class="form-group margem">
                          <a href="../formulario/duracao.php" class="btn btn-block btn-outline-success">Adicionar duração</a>
                        </div>
                      </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                    <table id="tabelaDuracao" class="table table-bordered table-striped" style="line-height: 0.8;">
                    <thead>
                        <tr>
                          <th title="Identificador da duração">Id duração</th>
                          <th title="Nome da duração">Nome</th>
                          <th title="Início (intervalo)">Início</th>
                          <th title="Final (intervalo)">Final</th>
                          <th title="Número de meses">Nº meses</th>
                          <th title="Anotação do período">Nota</th>
                        </tr>
                    </thead>
                    <tbody id="corpoTabela">
                        
                    </tbody>
                    </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
            </div>
        </section>
        <div class="modal fade" id="modal-updateDuracao">
        <div class="modal-dialog modal-lg">
          <div class="modal-content">
            <div class="modal-header" style="padding: 0.5rem;">
                <h3 class="card-title p-3"><p class="card-title breadcrumb-item active">Duração: <span id="nomeModal"></span></p></h3>
                <ul class="nav nav-pills ml-auto p-2">
                  <li class="nav-item" style="margin-right: 0.4rem;"><a class="nav-link active" href="#tab_info" data-toggle="tab">Informações</a></li>
                  <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" data-toggle="dropdown" href="#">
                      Acções <span class="caret"></span>
                    </a>
                    <div class="dropdown-menu">
                      <a class="dropdown-item" tabindex="-1" href="#tab_editar" data-toggle="tab">Editar</a>
                      <div class="dropdown-divider"></div>
                      <a class="dropdown-item" tabindex="-1" href="#btn-delete" id="btn-delete">Eliminar</a>
                    </div>
                  </li>
                </ul>
            </div>
            <div class="modal-body" style="padding-bottom: 0px;">
            <div class="tab-content">
              <div class="tab-pane active" id="tab_info">
              <div class="row">
                  <div class="col-md-12">
                    <form name="tabelaDuracao">
                      <table name="tabelaDuracao" class="table table-sm table-bordered" style="min-width: 100%;
                      max-width: 100%;">
                        <tr name="linhaItem">
                          <td style="padding: 20px 0px 0px 10px;">
                            <p>Código do duração: <span id="codigoInfo"></span></p>
                            <p>Nome do duração: <span id="nomeInfo"></span></p>
                            <p>Início duração: <span id="inicioInfo"></span></p>
                            <p>Final duração: <span id="finalInfo"></span></p>
                            <p>Duração (meses): <span id="mesInfo"></span></p>
                            <p>Nota duração: <span id="notaInfo"></span></p>
                          </td>
                        </tr>
                      </table>
                    </form>
                  </div>
                </div>
              </div>
              <!-- /.tab-pane -->
              <div class="tab-pane" id="tab_editar">
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group margem">
                    <input type="text" class="form-control" id="nome" name="nome" placeholder="*Nome duração" title="Duração do curso">
                    <small>Mensagem de erro</small>
                  </div>
                  <div class="form-group margem">
                  <div class="input-group">
                    <div class="input-group-prepend">
                      <span class="input-group-text">
                        <i class="far fa-calendar-alt"></i>
                      </span>
                    </div>
                    <input type="text" class="form-control float-right" id="duracao">
                  </div>
                  <small>Mensagem de erro</small>
                  <!-- /.input group -->
                </div>
                  <div class="form-group margem">
                    <textarea name="nota" class="form-control" id="nota" rows="4" placeholder="Nota..." title="Nota"></textarea>
                    <small>Mensagem de erro</small>
                  </div>
                  <div class="form-group">
                    <button type="submit" name="btn-submit" id="btn-submit" class="btn btn-block btn-outline-primary" disabled>Gravar alterações</button>
                  </div>
                </div>
          </div>
              </div>
            </div>
        </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
      </div>
    <!-- /.content -->
  </div>
  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->
<script src="../../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- DataTables  & Plugins -->
<script src="../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
<script src="../../plugins/moment/moment.min.js"></script>
<script src="../../plugins/daterangepicker/daterangepicker.js"></script>
<script src="../../plugins/jszip/jszip.min.js"></script>
<script src="../../plugins/pdfmake/pdfmake.min.js"></script>
<script src="../../plugins/pdfmake/vfs_fonts.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.html5.min.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.print.min.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.colVis.min.js"></script>
<script src="../../plugins/select2/js/select2.full.min.js"></script>
<!-- AdminLTE App -->
<script src="../../dist/js/adminlte.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="../../dist/js/demo.js"></script>
<script src="../../dist/js/sweetalert.min.js"></script>
<script src="../validation/formulario/duracao.js"></script>
<!-- Page specific script -->
<script>
  let inicio;
  let final;

  $(function () {
    //Initialize Select2 Elements
    $('.select2').select2()

    //Initialize Select2 Elements
    $('.select2bs4').select2({
      theme: 'bootstrap4'
    });

    $('#duracao').daterangepicker({
            locale: {
              format: 'DD/MM/YYYY'
            },
            opens: 'left'
          }, function(start, end, label){
            inicio = start.format('YYYY/MM/DD');
            final = end.format('YYYY/MM/DD');
            console.log("Início: ", start.format('DD/MM/YYYY'));
            console.log("Final: ", end.format('DD/MM/YYYY'));
          });
});

$(document).ready(function(){
    $.ajax({
        url: "../../php/selectAluno.php",
        type: "post",
        dataType: "json"
    }).done(function(data){
        console.log(data);
    });
});

$(document).ready(function(){
    $.ajax({
        url: "../../php/read/duracao.php",
        type: "post",
        dataType: "json"
    }).done(function(data){
        $("#tabelaDuracao").DataTable({
        "aaData": data,
        "columns": [{data: "idDuracao"}, {data: "nome"}, {data: "inicio"}, {data: "final"}, {data: "nMes"}, {data: "nota"}],
        "responsive": true, "lengthChange": false, "autoWidth": false, "language": idiomaPortugues, 
        lengthMenu: [[7, 25, 50, -1], [10, 25, 50, 'All']], 
        "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#tabelaDuracao_wrapper .col-md-6:eq(0)');
    });
});

var idiomaPortugues = {
  buttons: {
      copy: "Copiar",
      print: "Imprimir",
      colvis: "Visibilidade"
  },
  "sProcessing": "A processar...",
  "sLengthMenu": "Mostrar _MENU_ dos registros",
  "sZeroRecords": "Sem resultados!",
  "sEmptyTable": "Tabela sem dados disponíveis",
  "sInfo": "De _START_ à _END_ de um total de _TOTAL_ registros",
  "sInfoEmpty": "De 0 à 0 de um total de 0 registros",
  "sInfoFiltered": "(filtrado de um total de _MAX_ registros)",
  "sInfoPostFix": "",
  "sSearch": "Pesquisar:",
  "sUrl": "",
  "sInfoThousands": ",",
  "sLoadingRecords": "A carregar...",
  "oPaginate": {
      "sFirst": "Primeira",
      "sLast": "Última",
      "sNext": "Seguinte",
      "sPrevious": "Anterior"
  },
  "oAria": {
      "sSortAscending": ": Activar para ordenar a coluna de forma ascendente",
      "sSortDescending": ": Activar para ordenar a coluna de forma descendente"
  }
}

$('#tabelaDuracao tbody').on('click', 'td', function () {
    let tabela = document.getElementById("tabelaDuracao");
    
    for(i = 1; i < tabela.rows.length; i++){
      tabela.rows[i].ondblclick = function(){
          idDuracao = this.cells[0].innerHTML;
          nomeEdit = this.cells[1];
          inicioEdit = this.cells[2];
          finalEdit = this.cells[3];
          notaEdit = this.cells[5];
          console.log(idDuracao);
          ajax();
          //$('#modal-lg').modal('show');
          //this.classList.remove("selected");
      }
    }

    function ajax(){
      $.ajax({
        url: "../../php/read/queryDuracaoDois.php",
        type: "post",
        dataType: "json",
        data: {
          idDuracao: idDuracao
        },
        success: function(data){
          console.log(data);
          codigoInfo = document.getElementById("codigoInfo");
          nomeInfo = document.getElementById("nomeInfo");
          inicioInfo = document.getElementById("inicioInfo");
          finalInfo = document.getElementById("finalInfo");
          notaInfo = document.getElementById("notaInfo");

          nomeUpdate = document.getElementById("nome");
          notaUpdate = document.getElementById("nota");
          
          for(var key in data){
            console.log(data);
            nomeModal.innerText = data[key]['nome'];
            codigoInfo.innerText = data[key]['idDuracao'];
            nomeInfo.innerText = data[key]['nome'];
            inicioInfo.innerText = data[key]['inicio'];
            finalInfo.innerText = data[key]['final'];
            notaInfo.innerText = data[key]['nota'];

            nomeUpdate.value = data[key]['nome'];
            inicioUpdate = data[key]['inicio'];
            finalUpdate = data[key]['final'];
            console.log("Está aqui o final: ", finalUpdate);
            notaUpdate.value = data[key]['nota'];
          }
        }
      }).done(function(data){
        $('#modal-updateDuracao').modal('show');
      });
      
    }
});

$(document).on("click", "#btn-submit", function(e){
  e.preventDefault();
  console.log("Cliquei!!!");

  swal({
    title: "Tem a certeza que pretende editar dados?",
    text: "Duração: "+ nome.value,
    icon: "warning",
    buttons: true,
  })
  .then((willUpdate) => {
  if (willUpdate) {
   $.ajax({
        url: "../../php/update/duracao.php",
        type: "post",
        data: {
        idDuracao: idDuracao,
        nome: nomeUpdate.value,
        inicio: inicio,
        final: final,
        nota: notaUpdate.value
      },
      success: function(data){
        console.log(data);
        nomeEdit.innerText = nomeUpdate.value;
        inicioEdit.innerText = inicio;
        finalEdit.innerText = final;
        notaEdit.innerText = notaUpdate.value;
        updateTable();
        swal({
          title: "Alterações gravadas com sucesso!",
          text: "Duração "+ nomeUpdate.value +" editado!",
          icon: "success",
        });
      }
    });
  }
});
});

$(document).on("click", "#btn-delete", function(e){
  e.preventDefault();
  console.log(idDuracao);
  swal({
    title: "Tem a certeza que pretende eliminar duração?",
    text: "Duração: "+ nome.value,
    icon: "warning",
    buttons: true,
    dangerMode: true,
  })
  .then((willDelete) => {
    if (willDelete) {
      $.ajax({
        url: "../../php/delete/duracao.php",
        type: "post",
        dataType: "json",
        data: {
          idDuracao: idDuracao
      },
      success:function(data){
        console.log(data);
        updateTable();
        swal("Duração "+ nome.value +" eliminado com sucesso!", {
        icon: "success",
      });
      },
      error: function(data){
        swal({
          title: "Erro ao eliminar duração!",
          text: "Erro ao apagar duração: "+ nome.value +" !",
          icon: "error",
      });
      }
      });
    }
  });
});

function updateTable(){

$.ajax({
      url: "../../php/read/duracao.php",
      type: "post",
      dataType: "json"
  }).done(function(data){
    console.log("Está aqui a lista de alunos filtrada: ", data);
    $("#tabelaDuracao").DataTable().clear().draw();
    $("#tabelaDuracao").DataTable().rows.add(data);
    $("#tabelaDuracao").DataTable().columns.adjust().draw();
  });
}

</script>
</body>
</html>
