<!DOCTYPE html>
<html lang="pt-pt">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Formulário professor</title>
  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../../plugins/fontawesome-free/css/all.min.css">
  <!-- daterange picker -->
  <link rel="stylesheet" href="../../plugins/daterangepicker/daterangepicker.css">
  <!-- iCheck for checkboxes and radio inputs -->
  <link rel="stylesheet" href="../../plugins/icheck-bootstrap/icheck-bootstrap.min.css">
  <!-- Bootstrap Color Picker -->
  <link rel="stylesheet" href="../../plugins/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css">
  <!-- Tempusdominus Bootstrap 4 -->
  <link rel="stylesheet" href="../../plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css">
  <!-- Select2 -->
  <link rel="stylesheet" href="../../plugins/select2/css/select2.min.css">
  <link rel="stylesheet" href="../../plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css">
  <!-- Bootstrap4 Duallistbox -->
  <link rel="stylesheet" href="../../plugins/bootstrap4-duallistbox/bootstrap-duallistbox.min.css">
  <!-- BS Stepper -->
  <link rel="stylesheet" href="../../plugins/bs-stepper/css/bs-stepper.min.css">
  <!-- dropzonejs -->
  <link rel="stylesheet" href="../../plugins/dropzone/min/dropzone.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../../dist/css/adminlte.min.css">
  <link rel="stylesheet" href="../../style.css">
</head>
<body class="sidebar-mini iframe-mode">
<div class="wrapper">
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <section class="content-header" style="padding: 10px .5rem;">
        </section>

        <!-- Main content -->
        <section class="content">
            <form action="includes/usuario.inc.php" id="formularioProfessor" method="post" enctype="multipart/form-data">
                <div class="container-fluid">
                    <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                        <div class="card card-default">
                            <div class="card-header">
                              <div class="col-sm-6">
                                <div class="form-group margem">
                                  <p class="card-title breadcrumb-item active" style="padding: .375rem;">Formulário - Professor</p>
                                </div>
                              </div>
                              <div class="float-sm-right col-md-3">
                                <div class="form-group margem">
                                  <a href="../listagem/professor.php" class="btn btn-block btn-outline-success">Listagem professor</a>
                                </div>
                              </div>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                            <div class="row">
                                <div class="col-md-2" style="text-align: -webkit-center;">
                                    <div class="form-group margem">
                                        <div class="wrapper-image">
                                            <div class="image-container">
                                                <i class="fa fa-user"></i>
                                            </div>
                                            <label for="file" class="camera-icon">
                                            <i class="fas fa-camera"></i>
                                            </label>
                                            <input type="file" id="file" name="file" accept="image/*" hidden>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group margem">
                                      <small class="required">Nome Completo</small>
                                        <input type="text" class="form-control" id="nome" name="nome" placeholder="*Nome completo" title="Nome completo">
                                        <small>Mensagem de erro</small>
                                    </div>
                                    <div class="form-group margem">
                                      <small class="not-required">E-mail</small>
                                        <input type="email" class="form-control" id="email" name="email" placeholder="E-mail" title="E-mail">
                                        <small>Mensagem de erro</small>
                                    </div>
                                    <div class="form-group margem">
                                      <small class="required">Data de Nascimento</small>
                                        <input type="date" class="form-control" id="dataNasc" name="dataNasc" placeholder="Data de nascimento" title="Data de nascimento">
                                        <small>Mensagem de erro</small>
                                    </div>
                                </div>
                                <!-- /.col -->
                                <div class="col-md-3">
                                    <div class="form-group margem">
                                      <small class="not-required">Telefone</small>
                                        <input type="text" class="form-control" id="telefone" name="telefone" placeholder="Telefone" title="Número de telefone" data-inputmask='"mask": "999-999-999"' data-mask>
                                        <small>Mensagem de erro</small>
                                    </div>
                                    <div class="form-group margem">
                                      <small class="required">Endereço</small>
                                        <input type="text" class="form-control" id="endereco" name="endereco" placeholder="Endereço" title="Endereço">
                                        <small>Mensagem de erro</small>
                                    </div>
                                    <div class="form-group margem">
                                      <small class="required">Bilhete de Identidade</small>
                                        <input type="text" class="form-control" id="bi" name="bi" placeholder="Bilhete de identidade" title="Bilhete de identidade">
                                        <small>Mensagem de erro</small>
                                    </div>
                                </div>
                                <!-- /.col -->
                                <div class="col-md-3">
                                    <div class="form-group margem">
                                      <small class="required">Género</small>
                                        <select class="form-control select2" style="width: 100%;" id="genero" name="genero" title="Género (Masculino, Feminino)">
                                        <option value='0'>Selecione gênero</option>
                                        <option value="Masculino">Masculino</option>
                                        <option value="Feminino">Feminino</option>
                                        </select>
                                        <small>Mensagem de erro</small>
                                    </div>
                                    <div class="form-group margem">
                                      <small class="not-required">Tipo de Usuário</small>
                                        <select class="form-control select2" style="width: 100%;" id="tipoUsuario" name="tipoUsuario" title="Selecione um tipo de usuário" disabled>
                                          <option value='3'>Professor</option>
                                        </select>
                                        <small>Mensagem de erro</small>
                                    </div>
                                    <div class="form-group">
                                      <small>Botão</small>
                                        <button type="submit" name="btn-submit" id="btn-submit" class="btn btn-block btn-outline-primary" disabled>Cadastrar professor</button>
                                    </div>
                                </div>
                            </div>
                            </div>
                            <!-- /.card-body -->
                            <div class="card-footer" style="padding-bottom: 0;">
                                <div class="callout callout-info">
                                    <p><i class="icon fas fa-exclamation-triangle"></i>
                                    Nota: Crie professor, classe e turno antes de criar estudante.</p>
                                </div>
                            </div>
                        </div>
                        </div>
                        <!-- /.col -->
                    </div>
                    <!-- /.row -->
                </div>
            </form>
        </section>
  </div>
  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="../../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- Select2 -->
<script src="../../plugins/select2/js/select2.full.min.js"></script>
<!-- Bootstrap4 Duallistbox -->
<script src="../../plugins/bootstrap4-duallistbox/jquery.bootstrap-duallistbox.min.js"></script>
<!-- InputMask -->
<script src="../../plugins/moment/moment.min.js"></script>
<script src="../../plugins/inputmask/jquery.inputmask.min.js"></script>
<!-- date-range-picker -->
<script src="../../plugins/daterangepicker/daterangepicker.js"></script>
<!-- bootstrap color picker -->
<script src="../../plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js"></script>
<!-- Tempusdominus Bootstrap 4 -->
<script src="../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<!-- Bootstrap Switch -->
<script src="../../plugins/bootstrap-switch/js/bootstrap-switch.min.js"></script>
<!-- BS-Stepper -->
<script src="../../plugins/bs-stepper/js/bs-stepper.min.js"></script>
<!-- dropzonejs -->
<script src="../../plugins/dropzone/min/dropzone.min.js"></script>
<!-- AdminLTE App -->
<script src="../../dist/js/adminlte.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="../../dist/js/demo.js"></script>
<script src="../../image.js"></script>
<script src="../../dist/js/sweetalert.min.js"></script>
<script src="../validation/formulario/professor.js"></script>
<!-- Page specific script -->
<script>
  $(function () {
    //Initialize Select2 Elements
    $('.select2').select2()

    //Initialize Select2 Elements
    $('.select2bs4').select2({
      theme: 'bootstrap4'
    })

    //Datemask dd/mm/yyyy
    $('#datemask').inputmask('dd/mm/yyyy', { 'placeholder': 'dd/mm/yyyy' })
    //Datemask2 mm/dd/yyyy
    $('#datemask2').inputmask('mm/dd/yyyy', { 'placeholder': 'mm/dd/yyyy' })
    //Money Euro
    $('[data-mask]').inputmask()

    //Date picker
    $('#reservationdate').datetimepicker({
        format: 'L'
    });

    //Date and time picker
    $('#reservationdatetime').datetimepicker({ icons: { time: 'far fa-clock' } });

    //Date range picker
    $('#reservation').daterangepicker()
    //Date range picker with time picker
    $('#reservationtime').daterangepicker({
      timePicker: true,
      timePickerIncrement: 30,
      locale: {
        format: 'MM/DD/YYYY hh:mm A'
      }
    })
    //Date range as a button
    $('#daterange-btn').daterangepicker(
      {
        ranges   : {
          'Today'       : [moment(), moment()],
          'Yesterday'   : [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
          'Last 7 Days' : [moment().subtract(6, 'days'), moment()],
          'Last 30 Days': [moment().subtract(29, 'days'), moment()],
          'This Month'  : [moment().startOf('month'), moment().endOf('month')],
          'Last Month'  : [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        },
        startDate: moment().subtract(29, 'days'),
        endDate  : moment()
      },
      function (start, end) {
        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'))
      }
    )

    //Timepicker
    $('#timepicker').datetimepicker({
      format: 'LT'
    })

    //Bootstrap Duallistbox
    $('.duallistbox').bootstrapDualListbox()

    //Colorpicker
    $('.my-colorpicker1').colorpicker()
    //color picker with addon
    $('.my-colorpicker2').colorpicker()

    $('.my-colorpicker2').on('colorpickerChange', function(event) {
      $('.my-colorpicker2 .fa-square').css('color', event.color.toString());
    })

    $("input[data-bootstrap-switch]").each(function(){
      $(this).bootstrapSwitch('state', $(this).prop('checked'));
    })

  })
  // BS-Stepper Init
  document.addEventListener('DOMContentLoaded', function () {
    window.stepper = new Stepper(document.querySelector('.bs-stepper'))
  })

  // DropzoneJS Demo Code Start
  Dropzone.autoDiscover = false

  // Get the template HTML and remove it from the doumenthe template HTML and remove it from the doument
  var previewNode = document.querySelector("#template")
  previewNode.id = ""
  var previewTemplate = previewNode.parentNode.innerHTML
  previewNode.parentNode.removeChild(previewNode)

  var myDropzone = new Dropzone(document.body, { // Make the whole body a dropzone
    url: "/target-url", // Set the url
    thumbnailWidth: 80,
    thumbnailHeight: 80,
    parallelUploads: 20,
    previewTemplate: previewTemplate,
    autoQueue: false, // Make sure the files aren't queued until manually added
    previewsContainer: "#previews", // Define the container to display the previews
    clickable: ".fileinput-button" // Define the element that should be used as click trigger to select files.
  })

  myDropzone.on("addedfile", function(file) {
    // Hookup the start button
    file.previewElement.querySelector(".start").onclick = function() { myDropzone.enqueueFile(file) }
  })

  // Update the total progress bar
  myDropzone.on("totaluploadprogress", function(progress) {
    document.querySelector("#total-progress .progress-bar").style.width = progress + "%"
  })

  myDropzone.on("sending", function(file) {
    // Show the total progress bar when upload starts
    document.querySelector("#total-progress").style.opacity = "1"
    // And disable the start button
    file.previewElement.querySelector(".start").setAttribute("disabled", "disabled")
  })

  // Hide the total progress bar when nothing's uploading anymore
  myDropzone.on("queuecomplete", function(progress) {
    document.querySelector("#total-progress").style.opacity = "0"
  })

  // Setup the buttons for all transfers
  // The "add files" button doesn't need to be setup because the config
  // `clickable` has already been specified.
  document.querySelector("#actions .start").onclick = function() {
    myDropzone.enqueueFiles(myDropzone.getFilesWithStatus(Dropzone.ADDED))
  }
  document.querySelector("#actions .cancel").onclick = function() {
    myDropzone.removeAllFiles(true)
  }
  // DropzoneJS Demo Code End
</script>
<script>

  $(document).on("click", "#btn-submit", function(e){
  e.preventDefault();
  if(genero.value != 0 && dataNasc.value != ''){
    if(telefone.value == ''){
      telefone.value = 0;
    }
    let img = $("#file")[0].files;
    professor(img);
  }
});

function foto(identificador, img){
  let form_data = new FormData();
    form_data.append('id', identificador);
    form_data.append('imagem', img[0]);

  $.ajax({
      url: "../../php/create/foto.php",
      type: "post",
      data: form_data,
      cache: false,
      contentType: false,
      processData: false,
      success: function(data){
        console.log("Foto cadastrada com sucesso!");
      }
    });
}

function professor(img){
  $.ajax({
      url: "../../php/create/professor.php",
      type: "post",
      data: {
        nome: nome.value,
        email: email.value,
        dataNasc: dataNasc.value,
        telefone: telefone.value.replace(/-/g, ""),
        endereco: endereco.value,
        bi: bi.value,
        genero: genero.value,
        tipoUsuario: tipoUsuario.value
      },
      success: function(data){
        swal({
          title: "Cadastro efectuado com sucesso!",
          text: "Professor "+ nome.value +" cadastrado!",
          icon: "success",
        }).then(() => {
          codigoProfessor(data);
          if(img[0] != null){
            foto(data, img);
          }
        });
        nome.value = "";
        nome.className = "form-control";
        email.value = "";
        email.className = "form-control";
        dataNasc.value = "";
        dataNasc.className = "form-control";
        telefone.value = "";
        telefone.className = "form-control";
        endereco.value = "";
        endereco.className = "form-control";
        bi.value = "";
        bi.className = "form-control";
        btn.setAttribute('disabled', 'disabled');
      },
      error: function(data){
        swal({
          title: "Erro ao cadastrar professor!",
          text: "Erro ao cadastrar professor: "+ nome.value +" !",
          icon: "error",
      });
      }
    });
}

function codigoProfessor(idUsuario){
  $.ajax({
    url: "../../php/read/queryCodigoProfessor.php",
    type: "post",
    dataType: "json",
    data: {
      id: idUsuario
    },
    success: function(data){
      console.log("Está aqui o id: ", data[0]['nome']);
      
      setTimeout(function(){
        $(document).Toasts('create', {
        class: 'bg-info',
        title: 'Professor',
        subtitle: 'Informação',
        body: 'Código do professor: '+data[0]['descricao']+', Professor: '+data[0]['nome']+'',
        position: 'bottomRight'
      });
      }, 600);
    }
  });
}
</script>
</body>
</html>
