<!DOCTYPE html>
<html lang="pt-pt">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Formulário mensalidade</title>
  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../../plugins/fontawesome-free/css/all.min.css">
  <!-- daterange picker -->
  <link rel="stylesheet" href="../../plugins/daterangepicker/daterangepicker.css">
  <!-- iCheck for checkboxes and radio inputs -->
  <link rel="stylesheet" href="../../plugins/icheck-bootstrap/icheck-bootstrap.min.css">
  <!-- Bootstrap Color Picker -->
  <link rel="stylesheet" href="../../plugins/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css">
  <!-- Tempusdominus Bootstrap 4 -->
  <link rel="stylesheet" href="../../plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css">
  <!-- Select2 -->
  <link rel="stylesheet" href="../../plugins/select2/css/select2.min.css">
  <link rel="stylesheet" href="../../plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css">
  <!-- Bootstrap4 Duallistbox -->
  <link rel="stylesheet" href="../../plugins/bootstrap4-duallistbox/bootstrap-duallistbox.min.css">
  <!-- BS Stepper -->
  <link rel="stylesheet" href="../../plugins/bs-stepper/css/bs-stepper.min.css">
  <!-- dropzonejs -->
  <link rel="stylesheet" href="../../plugins/dropzone/min/dropzone.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../../dist/css/adminlte.min.css">
  <link rel="stylesheet" href="../../style.css">
</head>
<body class="sidebar-mini iframe-mode">
<div class="wrapper">
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <section class="content-header" style="padding: 10px .5rem;">
        </section>

        <!-- Main content -->
        <section class="content">
            <form action="includes/facturaCreate.inc.php" id="formFactura" method="post">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="card">
                                <div class="card-header">
                                    <div class="col-sm-6">
                                    <div class="form-group margem">
                                        <p class="card-title breadcrumb-item active" style="padding: .375rem;">Factura</p>
                                    </div>
                                    </div>
                                    <div class="card-tools" style="padding: .375rem;">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="form-group margem">
                                      <div class="input-group input-group">
                                        <input type="search" class="form-control form-control" id="codigo" name="codigo" placeholder="Pesquise" title="Pesquisar bilhete de identidade">
                                        <div class="input-group-append">
                                            <button type="button" id="btn-search" class="btn btn btn-default">
                                                <i class="fa fa-search"></i>
                                            </button>
                                        </div>
                                      </div>
                                      <small id="smallCodigo">Mensagem de erro</small>
                                    </div>
                                    <div class="form-group">
                                      <input type="text" class="form-control" id="nome" name="nome" placeholder="Aluno" title="Nome do aluno" disabled>
                                    </div>
                                    <div class="form-group">
                                      <input type="text" class="form-control" id="periodo" name="periodo" placeholder="Período" title="Período do aluno" disabled>
                                    </div>
                                    <div class="form-group">
                                      <input type="text" class="form-control" id="turma" name="turma" placeholder="Turma" title="Turma do aluno" disabled>
                                    </div>
                                    <div class="form-group">
                                      <input type="text" class="form-control" id="curso" name="curso" placeholder="Curso" title="Curso do aluno" disabled>
                                    </div>
                                    <div class="form-group">
                                        <select class="form-control select2" style="width: 100%;" id="tipoPagamento" name="tipoPagamento" title="Selecione um dos tipos de pagamentos">
                                        <option value="0">Tipo de pagamento</option>
                                        <option value="1">Não pago</option>
                                        <option value="2">Parcialmente pago</option>
                                        <option value="3">Totalmente pago</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <button type="button" name="btn-submit" id="btn-submit" class="btn btn-primary btn-block mb-3" disabled>Efectuar pagamento</button>
                            </div>
                        <div class="col-md-9">
                            <div class="card card-default">
                                <div class="card-header">
                                    <div class="col-sm-6">
                                      <div class="form-group margem">
                                          <p class="card-title breadcrumb-item active" style="padding: .375rem;">Formulário - Factura</p>
                                      </div>
                                    </div>
                                    <div class="float-sm-right">
                                    <div class="form-group margem">
                                        <a href="../listagem/factura.php" class="btn btn-block btn-outline-success">Listagem factura</a>
                                    </div>
                                    </div>
                                </div>
                                <!-- /.card-header -->
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <select class="form-control select2" style="width: 100%;" id="tipoArtigo" name="tipoArtigo" title="Selecione tipo artigo" disabled="disabled">
                                                <option value='0'>Selecione tipo artigo</option>
                                              </select>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <select class="form-control select2" style="width: 100%;" id="artigo" name="artigo" title="Selecione artigo" disabled="disabled">
                                                  <option value='0'>Selecione artigo</option>
                                              </select>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <form name="tabelaFactura">
                                            <table name="tabelaFactura" id="tabelaFactura" class="table table-hover table-sm table-bordered" style="min-width: 100%;
                                            max-width: 100%;">
                                            <thead class="table-primary">
                                            <tr style="text-align: center;">
                                                <th scope="col" style="width: 4%;">#</th>
                                                <th scope="col">Tipo de taxa</th>
                                                <th scope="col" style="width: 18%;">Montante (valor)</th>
                                                <th scope="col" style="width: 8%;">Qtd.</th>
                                                <th scope="col" style="width: 13%;">Desconto(%)</th>
                                                <th scope="col" style="width: 12%;">SubTotal</th>
                                                <th scope="col" style="width: 15%;">Qtd. entregue</th>
                                                <th scope="col" style="width: 13%;">Acção</th>
                                            </tr>
                                            </thead>
                                            <tbody id="corpoTabela">
                                                
                                            </tbody>
                                            <tfoot class="table-primary">
                                            <tr style="text-align: center;">
                                                <th scope="col" colspan="2">Total</th>
                                                <th scope="col" id="totalValor">0.00</th>
                                                <th scope="col" id="totalQtd">0.00</th>
                                                <th scope="col" id="totalDesconto">0.00</th>
                                                <th scope="col" id="totalSubTotal">0.00</th>
                                                <th scope="col" id="totalQtdPaga">0.00</th>
                                                <th scope="col"></th>
                                            </tr>
                                            </tfoot>
                                        </table>
                                      </form>
                                        </div>
                                    </div>
                                </div>
                                <!-- /.card-body -->
                                <div class="card-footer" style="padding-bottom: 0;">
                                    <div class="callout callout-info">
                                        <p><i class="icon fas fa-exclamation-triangle"></i>
                                        Nota: Selecione a classe, o estudante pertencente a classe, o tipo de pagamento e a taxa a pagar.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                </form>
                <div id="load"></div>
        </section>
  </div>
  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="../../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- Select2 -->
<script src="../../plugins/select2/js/select2.full.min.js"></script>
<!-- Bootstrap4 Duallistbox -->
<script src="../../plugins/bootstrap4-duallistbox/jquery.bootstrap-duallistbox.min.js"></script>
<!-- InputMask -->
<script src="../../plugins/moment/moment.min.js"></script>
<script src="../../plugins/inputmask/jquery.inputmask.min.js"></script>
<!-- date-range-picker -->
<script src="../../plugins/daterangepicker/daterangepicker.js"></script>
<!-- bootstrap color picker -->
<script src="../../plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js"></script>
<!-- Tempusdominus Bootstrap 4 -->
<script src="../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<!-- Bootstrap Switch -->
<script src="../../plugins/bootstrap-switch/js/bootstrap-switch.min.js"></script>
<!-- BS-Stepper -->
<script src="../../plugins/bs-stepper/js/bs-stepper.min.js"></script>
<!-- dropzonejs -->
<script src="../../plugins/dropzone/min/dropzone.min.js"></script>
<!-- AdminLTE App -->
<script src="../../dist/js/adminlte.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="../../dist/js/demo.js"></script>
<!--<script src="../validation/formulario/aluno.js"></script>-->
<script src="../../dist/js/sweetalert.min.js"></script>
<!-- Page specific script -->
<script>
  $(function () {
    //Initialize Select2 Elements
    $('.select2').select2()

    //Initialize Select2 Elements
    $('.select2bs4').select2({
      theme: 'bootstrap4'
    });
  
    //Datemask dd/mm/yyyy
    $('#datemask').inputmask('dd/mm/yyyy', { 'placeholder': 'dd/mm/yyyy' })
    //Datemask2 mm/dd/yyyy
    $('#datemask2').inputmask('mm/dd/yyyy', { 'placeholder': 'mm/dd/yyyy' })
    //Money Euro
    $('[data-mask]').inputmask()

    //Date picker
    $('#reservationdate').datetimepicker({
        format: 'L'
    });

    //Date and time picker
    $('#reservationdatetime').datetimepicker({ icons: { time: 'far fa-clock' } });

    //Date range picker
    $('#reservation').daterangepicker()
    //Date range picker with time picker
    $('#reservationtime').daterangepicker({
      timePicker: true,
      timePickerIncrement: 30,
      locale: {
        format: 'MM/DD/YYYY hh:mm A'
      }
    })
    //Date range as a button
    $('#daterange-btn').daterangepicker(
      {
        ranges   : {
          'Today'       : [moment(), moment()],
          'Yesterday'   : [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
          'Last 7 Days' : [moment().subtract(6, 'days'), moment()],
          'Last 30 Days': [moment().subtract(29, 'days'), moment()],
          'This Month'  : [moment().startOf('month'), moment().endOf('month')],
          'Last Month'  : [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        },
        startDate: moment().subtract(29, 'days'),
        endDate  : moment()
      },
      function (start, end) {
        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'))
      }
    )

    //Timepicker
    $('#timepicker').datetimepicker({
      format: 'LT'
    })

    //Bootstrap Duallistbox
    $('.duallistbox').bootstrapDualListbox()

    //Colorpicker
    $('.my-colorpicker1').colorpicker()
    //color picker with addon
    $('.my-colorpicker2').colorpicker()

    $('.my-colorpicker2').on('colorpickerChange', function(event) {
      $('.my-colorpicker2 .fa-square').css('color', event.color.toString());
    })

    $("input[data-bootstrap-switch]").each(function(){
      $(this).bootstrapSwitch('state', $(this).prop('checked'));
    })

  })
  // BS-Stepper Init
  document.addEventListener('DOMContentLoaded', function () {
    window.stepper = new Stepper(document.querySelector('.bs-stepper'))
  })

  // DropzoneJS Demo Code Start
  Dropzone.autoDiscover = false

  // Get the template HTML and remove it from the doumenthe template HTML and remove it from the doument
  var previewNode = document.querySelector("#template")
  previewNode.id = ""
  var previewTemplate = previewNode.parentNode.innerHTML
  previewNode.parentNode.removeChild(previewNode)

  var myDropzone = new Dropzone(document.body, { // Make the whole body a dropzone
    url: "/target-url", // Set the url
    thumbnailWidth: 80,
    thumbnailHeight: 80,
    parallelUploads: 20,
    previewTemplate: previewTemplate,
    autoQueue: false, // Make sure the files aren't queued until manually added
    previewsContainer: "#previews", // Define the container to display the previews
    clickable: ".fileinput-button" // Define the element that should be used as click trigger to select files.
  })

  myDropzone.on("addedfile", function(file) {
    // Hookup the start button
    file.previewElement.querySelector(".start").onclick = function() { myDropzone.enqueueFile(file) }
  })

  // Update the total progress bar
  myDropzone.on("totaluploadprogress", function(progress) {
    document.querySelector("#total-progress .progress-bar").style.width = progress + "%"
  })

  myDropzone.on("sending", function(file) {
    // Show the total progress bar when upload starts
    document.querySelector("#total-progress").style.opacity = "1"
    // And disable the start button
    file.previewElement.querySelector(".start").setAttribute("disabled", "disabled")
  })

  // Hide the total progress bar when nothing's uploading anymore
  myDropzone.on("queuecomplete", function(progress) {
    document.querySelector("#total-progress").style.opacity = "0"
  })

  // Setup the buttons for all transfers
  // The "add files" button doesn't need to be setup because the config
  // `clickable` has already been specified.
  document.querySelector("#actions .start").onclick = function() {
    myDropzone.enqueueFiles(myDropzone.getFilesWithStatus(Dropzone.ADDED))
  }
  document.querySelector("#actions .cancel").onclick = function() {
    myDropzone.removeAllFiles(true)
  }
  // DropzoneJS Demo Code End
</script>
<script>

let idCurso;
let idDuracao;
let idUsuario;
let codigo = document.getElementById("codigo");
let smallCodigo = document.getElementById("smallCodigo");
let nome = document.getElementById("nome");
let periodo = document.getElementById("periodo");
let turma = document.getElementById("turma");
let curso = document.getElementById("curso");
let tipoArtigo = document.getElementById("tipoArtigo");
let artigo = document.getElementById("artigo");
let table = document.getElementById("tabelaFactura");
let btn = document.getElementById("btn-submit");

console.log(smallCodigo);
        /*small.style.visibility = "visible";
		small.style.color = "#dc3545";
		small.innerText = "Selecione uma data!";
        dataNasc.className = "form-control is-invalid";
        btn.setAttribute('type', 'button');
*/

function artigoFactura(idFactura, preco){
  $.ajax({
    url: "../../php/create/artigoFactura.php",
    type: "post",
    data: {
      idFactura: idFactura,
      preco: preco
    }
  }).done(function(data){
      console.log(data);
  });
}

$(document).on("click", "#btn-submit", function(e){
  e.preventDefault();
  let tipoPagamento = document.getElementById("tipoPagamento");
  if(tipoPagamento.value !== "0"){
    console.log("Tipo de pagamento diferente de zero!");
    let tabela = document.getElementById("tabelaFactura");
  let ultimo = tabela.rows.length - 1;
  for(let i = 1; i < tabela.rows.length; i++){
    if(tabela.rows[i].rowIndex !== ultimo){
      console.log("É diferente: ", tabela.rows[i].cells[0].innerText);
      let preco = tabela.rows[i].cells[2].getElementsByTagName('input')[0].value;
      console.log("Preco: ", preco);
      artigoFactura(15, preco);
      /*$.ajax({
        url: "../../php/create/factura.php",
        type: "post",
        data: {
          idUsuario: idUsuario,
          montanteTotal: totalValor.innerText,
          descontoTotal: totalDesconto.innerText,
          subTotal: totalSubTotal.innerText,
          entregueTotal: totalQtdPaga.innerText,
          tipoPagamento: tipoPagamento.value
        },
      success: function(data){
        console.log("Esse é o id da factura: ", data);
        artigoFactura(data, preco);
        swal({
          title: "Pagamento efectuado com sucesso!",
          text: "Factura do aluno: "+ nome.value +" cadastrada!",
          icon: "success",
        });
      },
      error: function(data){
        swal({
          title: "Erro ao efectuar factura!",
          text: "Erro ao efectuar factura!",
          icon: "error",
      });
      }
    }).done(function(data){
        console.log(data);
    });*/
    }
  }
  }
  /*let totalValor = document.getElementById("totalValor");
  let totalDesconto = document.getElementById("totalDesconto");
  let totalSubTotal = document.getElementById("totalSubTotal");
  let totalQtdPaga = document.getElementById("totalQtdPaga");
  let tipoPagamento = document.getElementById("tipoPagamento");

  $.ajax({
        url: "../../php/create/factura.php",
        type: "post",
        data: {
          idUsuario: idUsuario,
          montanteTotal: totalValor.innerText,
          descontoTotal: totalDesconto.innerText,
          subTotal: totalSubTotal.innerText,
          entregueTotal: totalQtdPaga.innerText,
          tipoPagamento: tipoPagamento.value
        },
      success: function(){
        swal({
          title: "Pagamento efectuado com sucesso!",
          text: "Factura do aluno: "+ nome.value +" cadastrada!",
          icon: "success",
        });
      },
      error: function(data){
        swal({
          title: "Erro ao efectuar factura!",
          text: "Erro ao efectuar factura!",
          icon: "error",
      });
      }
    }).done(function(data){
        console.log(data);
    });*/
});

$(document).on("click", "#btn-search", function(e){
  e.preventDefault();
  if(codigo.value == ""){
    smallCodigo.style.visibility = "visible";
    smallCodigo.style.color = "#ffc107";
    smallCodigo.innerText = "Digite código do aluno!";
    nome.value = "";
    periodo.value = "";
    turma.value = "";
    curso.value = "";
  } else {
    $.ajax({
    url: "../../php/read/queryAlunoArtigo.php",
    type: "post",
    dataType: "json",
    data: {
      codigo: codigo.value
    },
    success: function(data){
      if(data == null){
        smallCodigo.style.visibility = "visible";
        smallCodigo.style.color = "#dc3545";
        smallCodigo.innerText = "Aluno inexistente!";
        nome.value = "";
        periodo.value = "";
        turma.value = "";
        curso.value = "";
        comboBoxInactive();
        btn.setAttribute('disabled', 'disabled');
      } else {
        smallCodigo.style.visibility = "hidden";
        nome.value = "Nome: " + data[0]["nome"];
        periodo.value = "Período: " + data[0]["nomePeriodo"];
        turma.value = "Turma: " + data[0]["nomeTurma"];
        curso.value = "Curso: " + data[0]["nomeCurso"];
        idDuracao = data[0]["idDuracao"];
        idCurso = data[0]["idCurso"];
        idUsuario = data[0]["idUsuario"];
        console.log("Id duração curso aluno: ", data[0]["idDuracao"]);
        comboBoxActive();
        btn.removeAttribute('disabled');
      }
    }
  });
  }
});

function comboBoxInactive(){
  tipoArtigo.setAttribute('disabled', 'disabled');
}

function comboBoxActive(){
  tipoArtigo.removeAttribute('disabled');
  $(document).ready(function(){
  $.ajax({
    url: "../../php/select/tipoArtigo.php",
    type: "post",
    dataType: "json",
    success: function(data){
      let select = "";
      select += "<option value='select'>Selecione tipo artigo</option><option value='0'>Mensalidade</option>";
      for(var key in data){
        select += "<option value="+data[key]['idTipoArtigo']+">"+data[key]['nome']+"</option>";
      }
      console.log(select);
      $("#tipoArtigo").html(select);
    }
  });
});
}

  let corpoTabela = document.getElementById("corpoTabela");

$(document).on("change", "#tipoArtigo", function(e){
  e.preventDefault();
  tipoArtigo = this.value;
  if(tipoArtigo == 0){
    console.log("Tipo de artigo zero!");
    $.ajax({
    url: "../../php/select/checkDuracao.php",
    type: "post",
    dataType: "json",
    data: {
      idDuracao: idDuracao
    },
    success: function(data){
      console.log(data);
      let select = "";
      select += "<option value='select'>Selecione artigo</option>";
      for(var key in data){
        select += "<option value="+[key]+">"+data[key]['mes']+"</option>";
      }
      console.log(select);
      artigo.removeAttribute('disabled');
      $("#artigo").html(select);
    
    }
  });
  } else {
    console.log("Tipo de artigo um!");
    $.ajax({
      url: "../../php/select/queryArtigo.php",
      type: "post",
      dataType: "json",
      data: {
        tipoArtigo: tipoArtigo
      },
      success: function(data){
        console.log(data);
        let select = "";
        select += "<option value='select'>Selecione artigo</option>";
        for(var key in data){
          select += "<option value="+data[key]["idArtigo"]+">"+data[key]['nome']+"</option>";
        }
        console.log(select);
        artigo.removeAttribute('disabled');
        $("#artigo").html(select);
      }
    });
  }
});

/*$(document).on("select2:select", "#artigo", function(e){
  e.preventDefault();
  console.log("Cliquei no artigo 2!");
});*/
$(document).ready(function(){
  var i = 0;
  $(document).on("change", "#artigo", function(e){
    e.preventDefault();
    i++;
    var artigo = $(this).select2('data');
    var tipo = $("#tipoArtigo").select2('data');
    let tabela;
    if( tipo[0].id == 0){
      console.log("Tipo de artigo: ", tipo[0].id);
        $.ajax({
          url: "../../php/read/queryCurso.php",
          type: "post",
          dataType: "json",
          data: {
            idCurso: idCurso
          },
          success: function(data){
            
            for(var key in data){
                tabela = `
                <tr id="row${i}" name="quantity[]" style="text-align: center;">
                  <td style="padding-top: 11px;">${i}</td>
                  <td style="padding-top: 11px;">${data[key]['nome']} (${artigo[0].text})</td>
                  <td><input class='form-control montante' type='text' name='taxa[]' value="${data[key]['preco']}" disabled></td>
                  <td><input class='form-control quant' type='text' name='quant[]' value="1"></td>
                  <td><input class='form-control desconto' type='text' name='desconto' value='0'></td><td><input class='form-control subtotal' type='text' name='subTotal' disabled></td>
                  <td><input class='form-control qtd' type='text' name='qtd'></td>
                  <td>
                    <button class='btn btn-block btn-outline-danger btn-delete remove_row' type='button' id='${i}' name='remove'>Remover</button>
                  </td>
                </tr>`;
            }
            $("#tabelaFactura tbody").append(tabela);
          }
        }).done(function(data){
          calcTotal();
          
        });
      } else {
        console.log("Tipo de artigo2: ", tipo[0].id);
        console.log("Artigo: ", artigo[0].id);
        $.ajax({
          url: "../../php/read/queryArtigo.php",
          type: "post",
          dataType: "json",
          data: {
            idArtigo: artigo[0].id
          },
          success: function(data){
            console.log(data);
            for(var key in data){
                tabela = `
                <tr id="row${i}" name="quantity[]" style="text-align: center;">
                  <td style="padding-top: 11px;">${i}</td>
                  <td style="padding-top: 11px;">${artigo[0].text}</td>
                  <td><input class='form-control montante' type='text' name='taxa' value=${data[key]['preco']} disabled></td>
                  <td><input class='form-control quant' type='text' name='quant' value="1"></td>
                  <td><input class='form-control desconto' type='text' name='desconto' value='0'></td>
                  <td><input class='form-control subtotal' type='text' name='subTotal' disabled></td>
                  <td><input class='form-control qtd' type='text' name='qtd'></td>
                  <td><button class='btn btn-block btn-outline-danger btn-delete remove_row' type='button' id='${i}' name='remove'>Remover</button></td>
                </tr>`;
            }
            $("#tabelaFactura tbody").append(tabela);
          }
        }).done(function(data){
          calcTotal();
          });
          }
          $(document).on("click", ".remove_row", function(e){
            var row_id = $(this).attr("id");
            $(`#row${row_id}`).remove();
            reCalcTotal();
          });
        });
      });

function reCalcTotal(){
  let montante = document.getElementsByClassName("montante");
  let desconto = document.getElementsByClassName("desconto");
  let subtotal = document.getElementsByClassName("subtotal");
  let qtd = document.getElementsByClassName("qtd");

  let totalValor = 0;
  let totalDesconto = 0;
  let totalSub = 0;
  let totalQtd = 0;

  for(let i = 0; i < montante.length; i++){
    totalValor += parseFloat(montante[i].value);
  }
  for(let i = 0; i < desconto.length; i++){
    totalDesconto += parseFloat(desconto[i].value);
  }
  for(let i = 0; i < montante.length; i++){
    for(let i = 0; i < subtotal.length; i++){
      subtotal[i].value = (montante[i].value * quant[i].value) - ((montante[i].value * quant[i].value) * (desconto[i].value / parseInt(100)));
      totalSub += parseFloat(subtotal[i].value);
    }
  }
  let totDesconto = document.getElementsByClassName("desconto");
  let total = 0;
  for(let i = 0; i < totDesconto.length; i++){
    total += parseFloat(totDesconto[i].value);
  }
  let totSub = document.getElementsByClassName("subtotal");
  let total2 = 0;
  for(let i = 0; i < totSub.length; i++){
    total2 += parseFloat(totSub[i].value);
  }
  let all = 0;
  let newQtd = document.getElementsByClassName("qtd");
  for(let i = 0; i < newQtd.length; i++){
    all += parseFloat(newQtd[i].value);
  }
  $("#totalQtdPaga").html(all.toString().replace(/\B(?=(\d{3})+(?!\d))/g, "."));
  $("#totalSubTotal").html(total2.toString().replace(/\B(?=(\d{3})+(?!\d))/g, "."));
  $("#totalDesconto").html(total.toString().replace(/\B(?=(\d{3})+(?!\d))/g, "."));
  $("#totalValor").html(totalValor.toString().replace(/\B(?=(\d{3})+(?!\d))/g, "."));
  $("#totalDesconto").html(totalDesconto.toString().replace(/\B(?=(\d{3})+(?!\d))/g, "."));
}
function calcTotal(){
  let quant = document.getElementsByClassName("quant");
  let montante = document.getElementsByClassName("montante");
              let desconto = document.getElementsByClassName("desconto");
              let subtotal = document.getElementsByClassName("subtotal");
              let qtd = document.getElementsByClassName("qtd");

              let totalValor = 0;
              let totalDesconto = 0;
              let totalSub = 0;
              let totalQtd = 0;
              let totalQuant = 0;

              for(let i = 0; i < quant.length; i++){
                  quant[i].addEventListener("keyup", function(){
                    let all = 0;
                    let newQtd = document.getElementsByClassName("quant");
                    for(let i = 0; i < newQtd.length; i++){
                      all += parseFloat(newQtd[i].value);
                    }
                    if(isNaN(all)){
                      $("#totalQtd").html("0.00");
                    } else {
                      $("#totalQtd").html(all.toString().replace(/\B(?=(\d{3})+(?!\d))/g, "."));
                    }
                  
                  });
                  quant[i].addEventListener("keypress", function(e){
                    var char = String.fromCharCode(e.which);
                    if(!(/[0-9]/.test(char))){
                      e.preventDefault();
                    }
                  });
                }

              for(let i = 0; i < quant.length; i++){
                totalQuant += parseFloat(quant[i].value);
              }

              for(let i = 0; i < quant.length; i++){
                quant[i].addEventListener("keyup", function(){
                  for(let i = 0; i < montante.length; i++){
                    for(let i = 0; i < subtotal.length; i++){
                      subtotal[i].value = (montante[i].value * quant[i].value) - ((montante[i].value * quant[i].value) * (desconto[i].value / parseInt(100)));
                      totalSub += parseFloat(subtotal[i].value);
                    }
                  }
                });
              }

              for(let i = 0; i < montante.length; i++){
                totalValor += parseFloat(montante[i].value);
              }
              
                for(let i = 0; i < desconto.length; i++){
                  desconto[i].addEventListener("keyup", function(){
                    for(let i = 0; i < montante.length; i++){
                      for(let i = 0; i < subtotal.length; i++){
                      subtotal[i].value = (montante[i].value * quant[i].value) - ((montante[i].value * quant[i].value) * (desconto[i].value / parseInt(100)));
                      totalSub += parseFloat(subtotal[i].value);
                    }
                    }
                    //totalDesconto += parseFloat(desconto[i].value);
                    //$("#totalDesconto").html(totalDesconto);
                    //$("#totalSubTotal").html(totalSub);
                    let totDesconto = document.getElementsByClassName("desconto");
                    let total = 0;
                    for(let i = 0; i < totDesconto.length; i++){
                      total += parseFloat(totDesconto[i].value);
                    }
                    if(isNaN(total)){
                      $("#totalDesconto").html("0.00");
                    } else {
                      $("#totalDesconto").html(total.toString().replace(/\B(?=(\d{3})+(?!\d))/g, "."));
                    }

                    let totSub = document.getElementsByClassName("subtotal");
                    let total2 = 0;
                    for(let i = 0; i < totSub.length; i++){
                      total2 += parseFloat(totSub[i].value);
                    }
                    if(isNaN(total2)){
                      $("#totalSubTotal").html("0.00");
                    } else {
                      $("#totalSubTotal").html(total2.toString().replace(/\B(?=(\d{3})+(?!\d))/g, "."));
                    }
                    
                  });
                  desconto[i].addEventListener("keypress", function(e){
                    var char = String.fromCharCode(e.which);
                    if(!(/[0-9]/.test(char))){
                      e.preventDefault();
                    }
                  });
                }

                for(let i = 0; i < qtd.length; i++){
                  qtd[i].addEventListener("keyup", function(){
                    let all = 0;
                    let newQtd = document.getElementsByClassName("qtd");
                    for(let i = 0; i < newQtd.length; i++){
                      all += parseFloat(newQtd[i].value);
                    }
                    if(isNaN(all)){
                      $("#totalQtdPaga").html("0.00");
                    } else {
                      $("#totalQtdPaga").html(all.toString().replace(/\B(?=(\d{3})+(?!\d))/g, "."));
                    }
                    
                    var valor = qtd[i].value;
                    valor = "34";
                    console.log("EStá aqui: ", valor);
                  });
                  qtd[i].addEventListener("keypress", function(e){
                    var char = (String.fromCharCode(e.which));
                    //var test = "30000000000";
                    //test = test.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
                    //console.log("Está aqui o test: ", test);
                    if(!(/[0-9]/.test(char))){
                      e.preventDefault();
                    }
                  });
                }
                if(isNaN(totalValor)){
                  $("#totalValor").html("0.00");
                } else {
                  $("#totalValor").html(totalValor.toString().replace(/\B(?=(\d{3})+(?!\d))/g, "."));
                }
                
                if(isNaN(totalQuant)){
                  $("#totalQtd").html("0.00");
                } else {
                  $("#totalQtd").html(totalQuant.toString().replace(/\B(?=(\d{3})+(?!\d))/g, "."));
                }
}

function remover(){
  var index, tabela = document.getElementById("tabelaFactura");
  for(var i = 1; i < tabela.rows.length; i++){
    tabela.rows[i].cells[6].addEventListener("click", function(){
      index = this.parentElement.rowIndex;
      //tabela.deleteRow(index);
      //console.log(index);
      
    });
  }
  //calcTotal();
}

</script>
</body>
</html>
