<?php
	class ProfessorController extends ProfessorModel {
		private $nomeCompleto;
		private $dataNasc;
		private $genero;
		private $bi;
		private $email;
		private $telefone;
        private $endereco;
        private $dataAdesao;
		private $comentario;
        private $nomeUsuario;
        private $senha;

		private $ficheiro;
		private $nomeFicheiro;
		private $tipoFicheiro;
		private $nomeTemporarioFicheiro;
		private $erroFicheiro;
		private $tamanhoFicheiro;
		private $extensaoFicheiro;
		private $extensaoActualFicheiro;
		private $permitido;

		private $nomeCompletoImagem;
		private $destinoFicheiro;

		public function __construct($nomeCompleto, $dataNasc, $genero, $bi, $email, $telefone, $endereco, $dataAdesao, $comentario, $nomeUsuario, $senha, $ficheiro, $nomeFicheiro, $tipoFicheiro, $nomeTemporarioFicheiro, $erroFicheiro, $tamanhoFicheiro, $extensaoFicheiro, $extensaoActualFicheiro, $permitido){
			$this->nomeCompleto = $nomeCompleto;
            $this->dataNasc = $dataNasc;
            $this->genero = $genero;
            $this->bi = $bi;
            $this->email = $email;
            $this->telefone = $telefone;
            $this->endereco = $endereco;
            $this->dataAdesao = $dataAdesao;
			$this->comentario = $comentario;
            $this->nomeUsuario = $nomeUsuario;
			$this->senha = $senha;

            $this->ficheiro = $ficheiro;
			$this->nomeFicheiro = $nomeFicheiro;
			$this->tipoFicheiro = $tipoFicheiro;
			$this->nomeTemporarioFicheiro = $nomeTemporarioFicheiro;
			$this->erroFicheiro = $erroFicheiro;
			$this->tamanhoFicheiro = $tamanhoFicheiro;
			$this->extensaoFicheiro = $extensaoFicheiro;
			$this->extensaoActualFicheiro = $extensaoActualFicheiro;
			$this->permitido = $permitido;
		}

		public function createProfessor(){
            $this->checks();
			$result = $this->insertProfessor($this->nomeCompleto, $this->dataNasc, $this->genero, $this->bi, $this->email, $this->telefone, $this->endereco, $this->dataAdesao, $this->comentario, $this->nomeUsuario, $this->senha, $this->ficheiro, $this->nomeFicheiro, $this->tipoFicheiro, $this->nomeTemporarioFicheiro, $this->erroFicheiro, $this->tamanhoFicheiro, $this->extensaoFicheiro, $this->extensaoActualFicheiro, $this->permitido, $this->nomeCompletoImagem, $this->destinoFicheiro);
			return $result;
		}
		public function emptyEntry(){
			if(empty($this->nomeCompleto)){
				$this->nomeCompleto = "professor";
				$result = false;
			} else {
				$this->nomeCompleto = strtolower(str_replace(" ", "-", $this->nomeCompleto));
				$result = true;
			}
			return $result;
		}

		public function emptyInput(){
			if(empty($this->nomeCompleto) || empty($this->comentario)){
				$result = false;
			} else {
				$result = true;
			}
			return $result;
		}

		public function checks(){
			if(in_array($this->extensaoActualFicheiro, $this->permitido)){
				if($this->erroFicheiro === 0){
					if($this->tamanhoFicheiro < 2000000){
						$this->nomeCompletoImagem = strtolower(str_replace(" ", "-", $this->nomeCompleto)) . "." . uniqid("", true) . "." . $this->extensaoActualFicheiro;
						$this->destinoFicheiro = "../images/fotoPerfil/" . $this->nomeCompletoImagem;

					} else {
						echo "Imagem demasiado grande! Carregue imagens de proporções menores!";
						exit();
					}
				} else {
					echo "Erro ao carregar imagem!";
					exit();
				}
			} else {
				$this->nomeCompletoImagem = "default" . "." . uniqid("", true) . "." . "png";
				$this->destinoFicheiro = "../images/" . $this->nomeCompletoImagem;
				//echo "Erro ao carregar tipo de imagem! Carregue imagens dos tipos: jpg, jpeg e png.";
				//exit();

			}
		}

	}