<?php
    class UsuarioModel extends Database {

		protected function insertUsuario($nome, $email, $dataNasc, $telefone, $endereco, $bi, $genero, $tipoUsuario){
			$stmt = $this->connect();
			
            $sql = "INSERT INTO usuario (nome, email, dataNasc, telefone, endereco, bi, genero, idTipoUsuario) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($nome, $email, $dataNasc, $telefone, $endereco, $bi, $genero, $tipoUsuario)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		protected function insertPeriodoCurso($idUsuario, $periodo, $curso){
			$stmt = $this->connect();
			$sql = "INSERT INTO periodoCursoAluno (aluno, periodo, curso) VALUES (?, ?, ?)";
			$query = $stmt->prepare($sql);
			$query->execute(array($idUsuario, $periodo, $curso));
        }

		protected function insertTurmaAluno($idTurma, $idAluno){
			$stmt = $this->connect();
			
            $sql = "INSERT INTO turmaaluno (turma, aluno) VALUES (?, ?)";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($idTurma, $idAluno)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		protected function tipoUsuario($idTipoUsuario){
			
		}

		public function readTurma(){
			$data = null;
			$sql = "SELECT * FROM turma";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function editTurma($idTurma, $capacidade){
			$stmt = $this->connect();
			
            $sql = "UPDATE turma SET capacidade = ? WHERE idTurma = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($capacidade, $idTurma)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		protected function readTipoUsuario($idUsuario){
			$data = null;
			$sql = "SELECT * FROM usuario WHERE idUsuario = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idUsuario]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function fotoPerfil($idUsuario){
			$data = null;
			$sql = "SELECT * FROM usuario WHERE idUsuario = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idUsuario]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function eraseUsuario($idUsuario){
			$stmt = $this->connect();
            $sql = "DELETE FROM usuario WHERE idUsuario = ?";
            $query = $stmt->prepare($sql);
			$img = $this->fotoPerfil($idUsuario);
			$nameImg = "../../images/fotoPerfil/" . $img[0]["imagem"];
			$fileInfo = glob($nameImg);
			$fileExt = explode(".", $fileInfo[0]);
			$fileActualExt = $fileExt[5];
        	$file = $nameImg;
			unlink($file);
            if(!($query->execute(array($idUsuario)))){
				$query = null;
				exit();
			}
		}

		protected function editUsuario($idUsuario, $nome, $email, $dataNasc, $telefone, $endereco, $bi, $genero, $tipoUsuario){
			$stmt = $this->connect();
			
            $sql = "UPDATE usuario SET nome = ?, email = ?, dataNasc = ?, telefone = ?, endereco = ?, bi = ?, genero = ?, idTipoUsuario = ? WHERE idUsuario = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($nome, $email, $dataNasc, $telefone, $endereco, $bi, $genero, $tipoUsuario, $idUsuario)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemAluno(){
			$data = null;
			$sql = "SELECT * FROM viewusuariotipoidentificador WHERE idTipoUsuario = 2";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function listagemProfessor(){
			$data = null;
			$sql = "SELECT * FROM viewusuariotipo WHERE idTipoUsuario = 3";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function listagemUsuario(){
			$data = null;
			$sql = "SELECT * FROM viewusuariotipoidentificador WHERE NOT idTipoUsuario BETWEEN 2 AND 3";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

        public function queryEmail($email){
			$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM usuario WHERE email = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$email]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryBi($bi){
			$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM usuario WHERE bi = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$bi]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryNomeUsuario($nomeUsuario){
			$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM usuario WHERE nomeUsuario = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$nomeUsuario]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function listaUsuario(){
			$data = null;
			$sql = "SELECT * FROM usuario";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryAluno($turma){
			$data = null;
			if($turma == 0){
				$sql = "SELECT * FROM turmaaluno ta INNER JOIN viewusuariotipo u ON (ta.aluno=u.idUsuario)";
				if($stmt = $this->connect()->query($sql)){
					while($row = $stmt->fetch()){
					$data[] = $row;
					}
				}
			} else {
				$sql = "SELECT * FROM turmaaluno ta INNER JOIN viewusuariotipo u ON (ta.aluno=u.idUsuario) WHERE ta.turma = ?";
				if($stmt = $this->connect()->prepare($sql)){
					$stmt->execute([$turma]);
					while($row = $stmt->fetch()){
					$data[] = $row;
					}
				}
			}
			return $data;
		}

		public function dataAluno($idAluno){
			$data = null;
			$sql = "SELECT * FROM viewdataaluno WHERE idTipoUsuario = 2 AND idUsuario = ? ORDER BY idUsuario ASC";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idAluno]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function dataUsuario($idUsuario){
			$data = null;
			$sql = "SELECT * FROM viewdatausuario WHERE NOT idTipoUsuario BETWEEN 2 AND 3 AND idUsuario = ? ORDER BY idUsuario ASC";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idUsuario]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function codigoUsuario($idUsuario){
			$data = null;
			$sql = "SELECT * FROM viewidentificadoruser WHERE idUsuario = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idUsuario]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryUsuario($idUsuario){
			$data = null;
			$sql = "SELECT * FROM usuario WHERE NOT idTipoUsuario BETWEEN 2 AND 3 AND idUsuario = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idUsuario]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryUser($idUsuario, $senha){
			$data = null;
			$sql = "SELECT * FROM usuario WHERE idUsuario = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idUsuario]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			$pwdHashed = $data[0]["senha"];
			$checkPwd = password_verify($senha, $pwdHashed);
			return $checkPwd;
		}

		public function updateSenha($idUsuario, $senha){
			$stmt = $this->connect();
			
            $sql = "UPDATE usuario SET senha = ? WHERE idUsuario = ?";
            $query = $stmt->prepare($sql);
			
			$hashedSenha = password_hash($senha, PASSWORD_DEFAULT);
            if(!($query->execute(array($hashedSenha, $idUsuario)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $senha;
        }
    }