<?php
    class PeriodoModel extends Database {

		protected function insertPeriodo($nome, $inicio, $final, $nota){
            $stmt = $this->connect();
            $sql = "INSERT INTO periodo (nome, inicio, final, nota) VALUES (?, ?, ?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($nome, $inicio, $final, $nota)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		protected function editPeriodo($idPeriodo, $nome, $inicio, $final, $nota){
			$stmt = $this->connect();
			
            $sql = "UPDATE periodo SET nome = ?, inicio = ?, final = ?, nota = ? WHERE idPeriodo = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($nome, $inicio, $final, $nota, $idPeriodo)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemPeriodo(){
			$data = null;
			$sql = "SELECT * FROM periodo";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryTipoTaxa($idTipoTaxa){
			$data = null;
			$sql = "SELECT * FROM tipotaxa WHERE idTipoTaxa = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idTipoTaxa]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

        public function listaTipoTaxa(){
			$data = null;
			$sql = "SELECT * FROM tipotaxa";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function dataPeriodo($idPeriodo){
			$data = null;
			$sql = "SELECT * FROM periodo WHERE idPeriodo = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idPeriodo]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function deletePeriodo($idPeriodo){
			$stmt = $this->connect();
            $sql = "DELETE FROM periodo WHERE idPeriodo = ?";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idPeriodo)))){
				$query = null;
				exit();
			}
		}
    }