<?php
	class EstudanteController extends EstudanteModel {
		private $idEncarregado;
		private $nomeCompleto;
		private $dataAdmissao;
		private $dataNasc;
		private $genero;
		private $email;
        private $bi;
        private $telefone;
        private $endereco;
        private $idClasse;
        private $idTurno;
        private $nomeUsuario;
        private $senha;

		private $ficheiro;
		private $nomeFicheiro;
		private $tipoFicheiro;
		private $nomeTemporarioFicheiro;
		private $erroFicheiro;
		private $tamanhoFicheiro;
		private $extensaoFicheiro;
		private $extensaoActualFicheiro;
		private $permitido;

		private $nomeCompletoImagem;
		private $destinoFicheiro;

		public function __construct($idEncarregado, $nomeCompleto, $dataAdmissao, $dataNasc, $genero, $email, $bi, $telefone, $endereco, $idClasse, $idTurno, $nomeUsuario, $senha, $ficheiro, $nomeFicheiro, $tipoFicheiro, $nomeTemporarioFicheiro, $erroFicheiro, $tamanhoFicheiro, $extensaoFicheiro, $extensaoActualFicheiro, $permitido){
            $this->idEncarregado = $idEncarregado;
			$this->nomeCompleto = $nomeCompleto;
            $this->dataAdmissao = $dataAdmissao;
            $this->dataNasc = $dataNasc;
            $this->genero = $genero;
            $this->email = $email;
            $this->bi = $bi;
            $this->telefone = $telefone;
            $this->endereco = $endereco;
            $this->idClasse = $idClasse;
            $this->idTurno = $idTurno;
            $this->nomeUsuario = $nomeUsuario;
			$this->senha = $senha;

            $this->ficheiro = $ficheiro;
			$this->nomeFicheiro = $nomeFicheiro;
			$this->tipoFicheiro = $tipoFicheiro;
			$this->nomeTemporarioFicheiro = $nomeTemporarioFicheiro;
			$this->erroFicheiro = $erroFicheiro;
			$this->tamanhoFicheiro = $tamanhoFicheiro;
			$this->extensaoFicheiro = $extensaoFicheiro;
			$this->extensaoActualFicheiro = $extensaoActualFicheiro;
			$this->permitido = $permitido;
		}

		public function createEstudante(){
            $this->checks();
			$result = $this->insertEstudante($this->idEncarregado, $this->nomeCompleto, $this->dataAdmissao, $this->dataNasc, $this->genero, $this->email, $this->bi, $this->telefone, $this->endereco, $this->idClasse, $this->idTurno, $this->nomeUsuario, $this->senha, $this->ficheiro, $this->nomeFicheiro, $this->tipoFicheiro, $this->nomeTemporarioFicheiro, $this->erroFicheiro, $this->tamanhoFicheiro, $this->extensaoFicheiro, $this->extensaoActualFicheiro, $this->permitido, $this->nomeCompletoImagem, $this->destinoFicheiro);
			return $result;
		}
		public function emptyEntry(){
			if(empty($this->nomeCompleto)){
				$this->nomeCompleto = "estudante";
				$result = false;
			} else {
				$this->nomeCompleto = strtolower(str_replace(" ", "-", $this->nomeCompleto));
				$result = true;
			}
			return $result;
		}

		public function emptyInput(){
			if(empty($this->nomeCompleto)){
				$result = false;
			} else {
				$result = true;
			}
			return $result;
		}

		public function checks(){
			if(in_array($this->extensaoActualFicheiro, $this->permitido)){
				if($this->erroFicheiro === 0){
					if($this->tamanhoFicheiro < 2000000){
						$this->nomeCompletoImagem = strtolower(str_replace(" ", "-", $this->nomeCompleto)) . "." . uniqid("", true) . "." . $this->extensaoActualFicheiro;
						$this->destinoFicheiro = "../images/fotoPerfil/" . $this->nomeCompletoImagem;

					} else {
						echo "Imagem demasiado grande! Carregue imagens de proporções menores!";
						exit();
					}
				} else {
					echo "Erro ao carregar imagem!";
					exit();
				}
			} else {
				$this->nomeCompletoImagem = "default" . "." . uniqid("", true) . "." . "png";
				$this->destinoFicheiro = "../images/" . $this->nomeCompletoImagem;
				//echo "Erro ao carregar tipo de imagem! Carregue imagens dos tipos: jpg, jpeg e png.";
				//exit();

			}
		}

	}