<?php
    class CursoModel extends Database {

		protected function insertCurso($nome, $periodo, $duracao, $preco, $nota){
            $stmt = $this->connect();
            $sql = "INSERT INTO curso (nome, idPeriodo, idDuracao, preco, nota) VALUES (?, ?, ?, ?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($nome, $periodo, $duracao, $preco, $nota)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		protected function editCurso($idCurso, $nome, $periodo, $duracao, $preco, $nota){
			$stmt = $this->connect();
			
            $sql = "UPDATE curso SET nome = ?, idPeriodo = ?, idDuracao = ?, preco = ?, nota = ? WHERE idCurso = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($nome, $periodo, $duracao, $preco, $nota, $idCurso)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemCurso(){
			$data = null;
			$sql = "SELECT * FROM viewcursoperiododuracao";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryCursoAluno($idCurso){
			$data = null;
			$sql = "SELECT * FROM curso WHERE idCurso = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idCurso]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryCursoDois($idCurso){
			$data = null;
			$sql = "SELECT * FROM viewcursoperiododuracao WHERE idCurso = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idCurso]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryCurso($periodo){
			$data = null;
			$sql = "SELECT * FROM curso WHERE idPeriodo = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$periodo]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function verifyTurmaCurso($curso){
			$data = null;
			$sql = "SELECT * FROM viewcursoturma WHERE capacidade = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$curso]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

        public function listaTipoTaxa(){
			$data = null;
			$sql = "SELECT * FROM tipotaxa";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function deleteCurso($idCurso){
			$stmt = $this->connect();
            $sql = "DELETE FROM curso WHERE idCurso = ?";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idCurso)))){
				$query = null;
				exit();
			}
		}
    }