$(document).ready(function(){

  idFamilia = "fm";
  $.ajax({
    url: "../../php/listaEstudante.php",
    type: "post",
    dataType: "json"
}).done(function(data){
  console.log("Vamos trazer os resultados: ", data);
  $("#tabelaAluno").DataTable({
    "aaData": data,
    "columns": [{data: "idEstudante"}, {data: "nomeCompleto"}, {data: "email"}, {data: "bi"}, {data: "telefone"}, {data: "endereco"}, {data: "idClasse"}, {data: "idTurno"}],
    "responsive": true, "lengthChange": false, "autoWidth": false, "language": idiomaPortugues, 
      lengthMenu: [[7, 25, 50, -1], [10, 25, 50, 'All']], 
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
  }).buttons().container().appendTo('#tabelaAluno_wrapper .col-md-6:eq(0)');
  $('#example2').DataTable({
    "paging": true,
    "lengthChange": false,
    "searching": false,
    "ordering": true,
    "info": true,
    "autoWidth": false,
    "responsive": true,
    });
  });
});

var idiomaPortugues = {
  buttons: {
      copy: "Copiar",
      print: "Imprimir",
      colvis: "Visibilidade"
  },
  "sProcessing": "A processar...",
  "sLengthMenu": "Mostrar _MENU_ dos registros",
  "sZeroRecords": "Sem resultados!",
  "sEmptyTable": "Tabela sem dados disponíveis",
  "sInfo": "De _START_ à _END_ de um total de _TOTAL_ registros",
  "sInfoEmpty": "De 0 à 0 de um total de 0 registros",
  "sInfoFiltered": "(filtrado de um total de _MAX_ registros)",
  "sInfoPostFix": "",
  "sSearch": "Pesquisar:",
  "sUrl": "",
  "sInfoThousands": ",",
  "sLoadingRecords": "A carregar...",
  "oPaginate": {
      "sFirst": "Primeira",
      "sLast": "Última",
      "sNext": "Seguinte",
      "sPrevious": "Anterior"
  },
  "oAria": {
      "sSortAscending": ": Activar para ordenar a coluna de forma ascendente",
      "sSortDescending": ": Activar para ordenar a coluna de forma descendente"
  }
}
let idEstudante;
let file;
let nomeUpdate;
let idEncarregadoUpdate;
let idClasseUpdate;
let idTurnoUpdate;
let generoUpdate;
let emailUpdate;
let telefoneUpdate;
let enderecoUpdate;
let nomeUsuarioUpdate;
let dataNascUpdate;
let dataAdmissaoUpdate;
let biUpdate;

$('#tabelaAluno tbody').on( 'click', 'td', function () {
    //alert($('#tabelaAluno').DataTable().cell(this).data());
    let tabela = document.getElementById("tabelaAluno");
    
    for(i = 1; i < tabela.rows.length; i++){
      tabela.rows[i].ondblclick = function(){
          idEstudante = this.cells[0].innerHTML;
          console.log(idEstudante);
          ajax();
          //$('#modal-lg').modal('show');
          //this.classList.remove("selected");
      }
    }

    function ajax(){
      $.ajax({
        url: "php/queryEstudante.php",
        type: "post",
        dataType: "json",
        data: {
          idEstudante: idEstudante
        },
        success: function(data){
          imagemInfo = document.getElementById("imagemInfo");
          nomeInfo = document.getElementById("nomeInfo");
          classeInfo = document.getElementById("classeInfo");
          turnoInfo = document.getElementById("turnoInfo");
          generoInfo = document.getElementById("generoInfo");
          emailInfo = document.getElementById("emailInfo");
          telefoneInfo = document.getElementById("telefoneInfo");
          enderecoInfo = document.getElementById("enderecoInfo");
          nomeUsuarioInfo = document.getElementById("nomeUsuarioInfo");
          dataNascInfo = document.getElementById("dataNascInfo");
          dataAdmissaoInfo = document.getElementById("dataAdmissaoInfo");
          biInfo = document.getElementById("biInfo");
          nomeModal = document.getElementById("nomeModal");

          nomeUpdate = document.getElementById("nomeCompleto");
          idEncarregadoUpdate = document.getElementById("encarregado");
          idClasseUpdate = document.getElementById("classe");
          idTurnoUpdate = document.getElementById("turno");
          generoUpdate = document.getElementById("genero");
          emailUpdate = document.getElementById("email");
          telefoneUpdate = document.getElementById("telefone");
          enderecoUpdate = document.getElementById("endereco");
          nomeUsuarioUpdate = document.getElementById("nomeUsuario");
          dataNascUpdate = document.getElementById("dataNasc");
          dataAdmissaoUpdate = document.getElementById("dataAdmissao");
          biUpdate = document.getElementById("bi");

          console.log("Está aqui a imagem: ", document.getElementById("file").value);
          
          for(var key in data){
            if(data[key]['imagem'] == null){
              imagemInfo.style.backgroundImage = "url('images/default.png')";
            } else {
              imagemInfo.style.backgroundImage = "url('images/fotoPerfil/" + data[key]['imagem'] + "')";
            }
            nomeModal.innerText = data[key]['nome'];
            nomeInfo.innerText = data[key]['nome'];
            classeInfo.innerText = data[key]['idClasse'];
            turnoInfo.innerText = data[key]['idTurno'];
            generoInfo.innerText = data[key]['genero'];
            emailInfo.innerText = data[key]['email'];
            telefoneInfo.innerText = data[key]['telefone'];
            enderecoInfo.innerText = data[key]['endereco'];
            nomeUsuarioInfo.innerText = data[key]['nomeUsuario'];
            dataNascInfo.innerText = data[key]['dataNasc'];
            dataAdmissaoInfo.innerText = data[key]['dataAdmissao'];
            biInfo.innerText = data[key]['bi'];

            document.querySelector(".image-container").style.backgroundImage = "url('images/fotoPerfil/" + data[key]['imagem'] + "')";
            document.querySelector(".image-container").querySelector("i").style.display = "none";

            nomeUpdate.value = data[key]['nome'];

            $('#classe').val(data[key]['idClasse']);
            $('#classe').select2().trigger('change');

            $('#turno').val(data[key]['idTurno']);
            $('#turno').select2().trigger('change');

            if(data[key]['idEncarregado'] == null){
              $('#encarregado').val(0);
              $('#encarregado').select2().trigger('change');
            } else {
              $('#encarregado').val(data[key]['idEncarregado']);
              $('#encarregado').select2().trigger('change');
            }

            $('#genero').val(data[key]['genero']);
            $('#genero').select2().trigger('change');

            //classeUpdate.value = data[key]['idClasse'];
            //turnoUpdate.value = data[key]['idTurno'];
            //generoUpdate.value = data[key]['genero'];
            emailUpdate.value = data[key]['email'];
            telefoneUpdate.value = data[key]['telefone'];
            enderecoUpdate.value = data[key]['endereco'];
            nomeUsuarioUpdate.value = data[key]['nomeUsuario'];
            dataNascUpdate.value = data[key]['dataNasc'];
            dataAdmissaoUpdate.value = data[key]['dataAdmissao'];
            biUpdate.value = data[key]['bi'];
          }
        }
      }).done(function(data){
        $('#modal-lg').modal('show');
      });
    }
});

$(document).on("click", "#btn-submit", function(e){
  e.preventDefault();

  let nomeUpdate;
  let idEncarregadoUpdate;
  let idClasseUpdate;
  let idTurnoUpdate;
  let generoUpdate;
  let emailUpdate;
  let telefoneUpdate;
  let enderecoUpdate;
  let nomeUsuarioUpdate;
  let dataNascUpdate;
  let dataAdmissaoUpdate;
  let biUpdate;

  /*$.ajax({
    url: "php/queryListaEstudante.php",
    type: "post",
    dataType: "json",
    data: {
      idEstudante: idEstudante,
      nome: nomeUpdate,
      idEncarregado: idEncarregadoUpdate,
      idClasse: idClasseUpdate,
      idTurno: idTurnoUpdate,
      genero: generoUpdate,
      email: emailUpdate,
      telefone: telefoneUpdate,
      endereco: enderecoUpdate,
      nomeUsuario: nomeUsuarioUpdate,
      dataNasc: dataNascUpdate,
      dataAdmissao: dataAdmissaoUpdate,
      bi: biUpdate
    }
    });*/
});